/*
 * @(#)GeneralizationConnectionTool.java  2.0  2008-03-31
 *
 * Copyright (c) 2006-2008 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */
package ch.hslu.cm.cer.diagram;

import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.jhotdraw.undo.CompositeEdit;

/**
 * GeneralizationConnectionTool.
 *
 *
 * @author Werner Randelshofer
 * @version 2.0 2008-03-31 Reworked for JHotDraw 7.1. 
 * <br>1.0 27. March 2006 Created.
 */
public class CERAttributeConnectionTool extends ConnectionTool {

    public CERAttributeConnectionTool(CERConnectionFigure prototype) {
        super(prototype);
    }

    public CERAttributeConnectionTool(CERConnectionFigure prototype, Map attributes) {
        super(prototype, attributes);
    }

    @Override
    protected boolean canConnect(ConnectionFigure f, Connector startConnector) {
        Figure start = startConnector.getOwner();
        return f.canConnect(startConnector) &&
                ((start instanceof CEREntitySetFigure) || (start instanceof CERAttributeFigure) ||
                (start instanceof CERRelationshipSetFigure));
    }

    @Override
    protected boolean canConnect(ConnectionFigure f, Connector startConnector, Connector endConnector) {
        Figure start = startConnector.getOwner();
        Figure end = endConnector.getOwner();
        return f.canConnect(startConnector, endConnector) &&
                ((start instanceof CERAttributeFigure) || (end instanceof CERAttributeFigure));
    }

    /**
     * If the mouse is released over another figure, connects the figures, 
     * otherwise creates a new CERAttributeFigure and connects to it.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (endConnector == null) {
            CompositeEdit creationEdit = new CompositeEdit("Verbindung erstellen");
            getDrawing().fireUndoableEditHappened(creationEdit);
            CERAttributeFigure rsf = new CERAttributeFigure();
            Point2D.Double p = getView().viewToDrawing(e.getPoint());
            rsf.setBounds(p, p);


            getDrawing().add(rsf);
            endConnector = rsf.findConnector(p, createdFigure);
            super.mouseReleased(e);
            getDrawing().fireUndoableEditHappened(creationEdit);
        } else {
            super.mouseReleased(e);
        }
    }
}
